function [punc_tmp] = vector_cal_test(ori_data,termini_data,filenames)
%In the following function, i = total of all start points in punc_data for
%a specific channel.  j = total of all terminal points from the start
%points in i; essentially, z steps in the closest_pt cell array, of that
%channel.  k = number of start points in i. l = second terminal point, of another 
%channel not j, that is used to calculate the angle; essentially, z step in
%the closest_pt cell array, not i or j.  m = number of terminal point (j) per 
%start point for channel i.

if size(filenames,2)>2       %needs at least 3 data sets
    h = waitbar(0,['Data Sets Analyzed: ',filenames{1}],'position',[20 300 275 50]);    %initialize progress bar.
    for i = 1:size(filenames,2)      %calculate for each data set
        h2 = waitbar(0,['Comparing Data Set: ',filenames{1}],'position',[20 200 275 50]);    %initialize progress bar.
        for j = 1:size(filenames,2)  %step through each other data set
            if i~=j             %skip the self on self comparision
                h3 = waitbar(0,'Vertex Vector Analyzed: 0');    %initialize progress bar.
                for k = 1:size(ori_data{i,1},1)   %step through the verticies or pivots of channel j
                    ori = ori_data{i,1}{k,:,j};  %the center point from which all vectors are drawn
                    first_pt = termini_data{i,1}{k,:,j};     %the termination point of the base vector
                    %calculate the base vector for the xy plane
                    ori_xy = ori(:,1:2)';        %array of the xy position of the origin
                    first_xy = first_pt(:,1:2)';        %array of the xy position of the termini of the base vector
                    base_xy_dist = first_xy - ori_xy;    %array of the x & y distance apart
                    base_xy_v = hypot(base_xy_dist(1,:),base_xy_dist(2,:));   %arry of vector distances for the base vector
                    %calculate the base vector for the xz plane
                    ori_xz = ori(:,1:2:3)';      %array of the xz position of the origin
                    first_xz = first_pt(:,1:2:3)';      %array of the xz position of the termini of the base vector
                    base_xz_dist = first_xz - ori_xz;    %array of the x & y distance apart
                    base_xz_v = hypot(base_xz_dist(1,:),base_xz_dist(2,:));   %arry of vector distances for the base vector
                    %calculate the base vector for the coplaner case
                    base_xyz_dist = first_pt'-ori';       %array of x, y & z distances
                    base_xyz_v = sqrt(sum(base_xyz_dist.^2));   %array of vector distances for the base vector
                    for l = 1:size(filenames,2)    %step through the rest of dataset to find the second vector and the angle
                        if l~=j && l~=i                     %skip the original vector datasets
                            for m = 1:size(ori,1)           %for each origin to first point vector test all second point vectors.
                                second_pt = termini_data{i,1}{k,:,l};   %get the termini for the second vector
                                second_xy = second_pt(:,1:2)';                      %Array of xy positions for the termini of the comparision vector
                                second_xz = second_pt(:,1:2:3)';                    %Array of xz positions for the termini of the comparision vector
                                ori_xy_tmp = repmat(ori_xy(:,m),1,size(second_xy,2));   %match the origin arrays with the second point arrays
                                ori_xz_tmp = repmat(ori_xy(:,m),1,size(second_xy,2));
                                first_xy_tmp = repmat(first_xy(:,m),1,size(second_xy,2));   %match the first arrays with the second point arrays
                                first_xz_tmp = repmat(first_xy(:,m),1,size(second_xy,2));
                                base_xy_dist_tmp = repmat(base_xy_dist(:,m),1,size(second_xy,2)); %match the dist arrays with the second point arrays
                                base_xz_dist_tmp = repmat(base_xy_dist(:,m),1,size(second_xy,2));
                                base_xyz_dist_tmp = repmat(base_xyz_dist(:,m),1,size(second_xy,2));
                                base_xy_v_tmp = repmat(base_xy_v(:,m),1,size(second_xy,2)); %match the vector arrays with the second point arrays
                                base_xz_v_tmp = repmat(base_xy_v(:,m),1,size(second_xy,2));
                                base_xyz_v_tmp = repmat(base_xyz_v(:,m),1,size(second_xy,2));
                                ori_tmp = repmat(ori(m,:),size(second_pt,1),1);
                                %calculate in xy plane
                                comp_xy_dist = second_xy - ori_xy_tmp;              %array of the x & y distances
                                comp_xy_v = hypot(comp_xy_dist(1,:),comp_xy_dist(2,:));   %array of vector distances for the comparision vector
                                dot_xy = dot(base_xy_dist_tmp,comp_xy_dist); %get the dot product of the two vectors
                                angles_xy_tmp{m,1} = (acos(dot_xy./(base_xy_v_tmp.*comp_xy_v))*180/pi)';  %calculate the angle.
                                %calculate whether the angle is left or right of the
                                %vector
                                [angles_pos_xy_tmp{m,1}] = angle_position(ori_xy_tmp,first_xy_tmp,second_xy)';
                                %calculate in xz plane
                                comp_xz_dist = second_xz - ori_xz_tmp;              %array of the x & z distances
                                comp_xz_v = hypot(comp_xz_dist(1,:),comp_xz_dist(2,:));   %array of vector distances for the comparision vector
                                dot_xz = dot(base_xz_dist_tmp,comp_xz_dist); %get the dot product of the two vectors
                                angles_xz_tmp{m,1} = (acos(dot_xz./(base_xz_v_tmp.*comp_xz_v))*180/pi)';  %calculate the angle.
                                %calculate whether the angle is left or right of the
                                %vector
                                [angles_pos_xz_tmp{m,1}] = angle_position(ori_xz_tmp,first_xz_tmp,second_xz)';
                                %calculate in the coplanar plane for the two vectors
                                comp_xyz_dist = second_pt' - ori_tmp';                  %arry of x, y and z distances
                                comp_xyz_v = sqrt(sum(comp_xyz_dist.^2));       %array of vector distances for the comparision vector
                                dot_xyz = dot(base_xyz_dist_tmp,comp_xyz_dist); %the dot product of the two vectors
                                angles_xyz_tmp{m,1} = (acos(dot_xyz./(base_xyz_v_tmp.*comp_xyz_v))*180/pi)';    %calculate the angle.
                                
                                %create a data structure for storing the data
                                angles_xy{k,l,j} = angles_xy_tmp;       %store the angles in a cell array.
                                angles_xz{k,l,j} = angles_xz_tmp;
                                angles_xyz{k,l,j} = angles_xyz_tmp;
                                angles_pos_xy{k,l,j} = angles_pos_xy_tmp;
                                angles_pos_xz{k,l,j} = angles_pos_xz_tmp;
                                %clear all of the temporary data
                                if m==size(ori,1)
                                    clear angles_xy_tmp angles_xz_tmp angles_xyz_tmp angles_pos_xy_tmp angles_pos_xz_tmp
                                end
                            end
                        end
                    end
                    waitbar(k/size(ori_data{i,1},1),h3,['Vertex Vector Analyzed: ',num2str(k)]);   %update progress
                end
                
                close(h3);   %close progress bar
                waitbar(j/size(filenames,2),h2,['Comparing Data Set: ',filenames{j}]);   %update progress
            end
        end
        %store angles for output
        punc_tmp(i).angles_xy = angles_xy;
        punc_tmp(i).angles_xz = angles_xz;
        punc_tmp(i).angles_xyz = angles_xyz;
        punc_tmp(i).angles_pos_xy = angles_pos_xy;
        punc_tmp(i).angles_pos_xz = angles_pos_xz;
        
        %clear holder data arrays
        clear angles_xy angles_xz angles_xyz angles_pos_xy angles_pos_xz
        close(h2);
        waitbar(i/size(filenames,2),h,['Data Sets Analyzed: ',filenames{i}]);   %update progress
    end
    close(h);
end

%--------------------------------------------------------------------------
%subfunction to calculate the left of right handedness of the angle
function [a_pos] = angle_position(ori_mg,first_mg,second_mg)
%To determine whether a second vector is to left or right of a base vector
%you take the magnitudes, here the unit vector is 1 in cartesian xyz, of
%each component vector in two directions for each vector.  You then add the
%components of the two vectors together, which will give you the unit
%vector description of the total vector.  You then calculate the ratio of
%the component magnitudes in the base vector, and also calculate the ratio
%of the component magnitubes in the combined vector, and ask if the base
%ratio is greater than the combined ratio.  If it is, then the second 
%vector is left or above the base vector, but it is not then the second
%vector is right or below the base vector.

v1 = first_mg-ori_mg;       %the magnitudes of the xy components of the first vector.
v2 = second_mg-ori_mg;      %the magnitudes of the xy components of the second vector.
v_sum = v1+v2;              %add the vectors to create a total vector
v1_ratio = v1(1,:)./v1(2,:); %get the ratio of the two magnitudes for the base vector.
v_sum_ratio = v_sum(1,:)./v_sum(2,:);    %get the ratio of the magnitudes in the combined vector.
a_pos = v1_ratio-v_sum_ratio;       %to get the angle position first subtract the two ratios
a_pos(a_pos>=0) = 1;            %if the combined ratio is smaller than the base ratio, the angle is left of the vector
a_pos(a_pos<0) = -1;            %if the combined ratio is larger than the base ration,the angle is right of the vector
%keyboard